#ifndef NASCCL_KeyGen_Cpp
#define NASCCL_KeyGen_Cpp
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
    The GenerateSeed function will generate a seed for use with randomization functions and
        the Generatekey function can be used to generate keys of any length.
*/

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include <Windows.H>

#include "NASCCL.H"
#include "sBoxes.H"
#include "Math.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int GenerateSeed(void)
{
	srand( GetTickCount() );
	return rand();
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GenerateKey(int inKeyLength, int inSeed, int inAttribute, void *outNewKey)
{
	bool ValidValue 		= false;

	int LocalLoop			= 0;
	unsigned char Random	= 0;
	unsigned char LastValue = 0;

	if(inAttribute &GKNUMBERS)  ValidValue = true;
	if(inAttribute &GKUPPER_AZ) ValidValue = true;
	if(inAttribute &GKLOWER_AZ) ValidValue = true;
	if(inAttribute &GKBROADKEY) ValidValue = true;

	if(!ValidValue)
        return false;

	ValidValue = false;

	srand( inSeed );

	while(LocalLoop < inKeyLength)
	{
		Random = (unsigned char) rand() % 256;

		if(inAttribute &GKNUMBERS)  // 0 - 9
        {
			if( (Random < 57) && (Random > 48) )
            {
                ValidValue = true;
            }
        }

		if(inAttribute &GKUPPER_AZ) // A - Z
        {
			if( (Random < 90) && (Random > 65) )
            {
                ValidValue = true;
            }
        }

		if(inAttribute &GKLOWER_AZ) // a - z
        {
			if( (Random < 122) && (Random > 97) )
            {
                ValidValue = true;
            }
        }

		if(inAttribute &GKBROADKEY) // Broad Key
			ValidValue = true;

		if(Random == 0)
            ValidValue = false; // Null
		else if(Random == 10)
            ValidValue = false; // lf
		else if(Random == 13)
            ValidValue = false; // cr

        if(inAttribute &GKNONREPETITION)
        {
    		if(Random == LastValue)
            {
                ValidValue = false;
            }
        }

		if(ValidValue == TRUE)
		{
			((NASCCLByte *)outNewKey)[LocalLoop] = Random;
			LastValue = Random;
			LocalLoop++;
		}

		ValidValue = false;
	}

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

